/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.modem;

import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.comm.PortManager;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.modem.ConfigRemoteModemModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfigRemoteModemPanel
extends WizardInputPanel {
    private static final long serialVersionUID = 1L;
    private JPanel connectRemoteModemPanel;
    private JPanel configPanel;
    private JCheckBox remoteModemDoneCheckBox;
    private JButton configButton;
    private ConfigRemoteModemModel model;
    private JPanel interfacePanel;
    private JLabel interfaceLabel;
    private JComboBox interfaceCombobox;

    public Icon getIcon() {
        return Global.getIcon("ConfigRemoteModem.gif");
    }

    public void setLabels() {
        this.title = Language.getString("dialog.options.connectionTab.testButtonText", "Configure remote modem");
    }

    public ConfigRemoteModemPanel(WizardPanelModel panelModel) {
        super(panelModel);
        this.model = (ConfigRemoteModemModel)panelModel;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 8, 0, 0);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)new JLabel(this.getIcon()), constraints);
        constraints.insets = new Insets(10, 8, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)this.getConnectRemoteModemPanel(), constraints);
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 8, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 2;
        this.add((Component)this.getInterfacePanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        this.add((Component)this.getConfigPanel(), constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        this.add((Component)new JPanel(), constraints);
    }

    private JPanel getInterfacePanel() {
        if (this.interfacePanel == null) {
            this.interfacePanel = new JPanel(new FlowLayout(0));
            this.interfaceLabel = new JLabel(Language.getString("wizard.modem.configRemoteModemPanel.selectInterface", "Select port"));
            this.interfaceCombobox = new JComboBox(PortManager.getAvailableComPorts());
            this.interfacePanel.add(this.interfaceLabel);
            this.interfacePanel.add(this.interfaceCombobox);
        }
        return this.interfacePanel;
    }

    private JPanel getConnectRemoteModemPanel() {
        if (this.connectRemoteModemPanel == null) {
            this.connectRemoteModemPanel = new JPanel(new FlowLayout(0));
            this.remoteModemDoneCheckBox = new JCheckBox(Language.getString("log.msg.done", "Done"));
            this.connectRemoteModemPanel.add(new JLabel(Language.getString("wizard.modem.configRemoteModemPanel.connectModem", "Connect the remote modem to computer")));
            this.connectRemoteModemPanel.add(this.remoteModemDoneCheckBox);
        }
        return this.connectRemoteModemPanel;
    }

    private JPanel getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new JPanel(new FlowLayout(0));
            this.configButton = new JButton(Language.getString("dialog.options.connectionTab.testButtonText", "Configure remote modem"));
            this.configButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (!ConfigRemoteModemPanel.this.remoteModemDoneCheckBox.isSelected()) {
                        new LogoError(null, "wizard.modem.configRemoteModemPanel.doneNotSelected", "You must connect your remote modem to the computer and select \"Done\".", 0).display();
                    } else {
                        String portName = ConfigRemoteModemPanel.this.interfaceCombobox.getSelectedItem().toString();
                        if (Modem.configRemoteModem(portName, ((ConfigRemoteModemModel)ConfigRemoteModemPanel.this.panelModel).getRemoteATCommandString())) {
                            ConfigRemoteModemPanel.this.model.setCanNext(true);
                            Log.println(Language.getString("modem.remoteConfigOK", "Remote modem configured."));
                        } else {
                            ConfigRemoteModemPanel.this.model.setCanNext(false);
                            new LogoError(null, "modem.err.remoteConfigFailed", "Remote modem configure failed.", 0, 0).display();
                        }
                    }
                }
            });
            this.configPanel.add(this.configButton);
        }
        return this.configPanel;
    }

    public String getHelpIdString() {
        return "extras.configRemoteModem";
    }
}

